# Copyright (C) 2026 BoundWare LLC. All rights reserved.
# SnacTrac is licensed under the Apache License, Version 2.0
# See Licenses/LICENSE.txt for details.


import PySimpleGUI as sg
from append_triggers import *
from asset_image_banner_snactrac import *
from asset_image_icon_snactrac import *
from authenticate_user import *
from get_value_setting import *
from get_value_table import *
from get_version import *
from move_window_center import *
from play_sound import *
from window_popup_general import *


# Handle welcome window interaction.
def window_welcome():

    timeout = 0

    triggers = []

    layout = [
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 19),
                pad=(0, 0),
            ),
        ],
        [
            sg.Push(),
            sg.Image(
                source=banner_snactrac,
                pad=(0, 0),
            ),
            sg.Push(),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 24),
                pad=(0, 0),
            ),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(10, 0),
                pad=(0, 0),
            ),
            sg.Text(
                text="Username:",
                font=("Roboto", 12),
                pad=(0, 0),
            ),
            sg.Frame(
                title=None,
                layout=[],
                size=(42, 0),
                pad=(0, 0),
            ),
            sg.Frame(
                title=None,
                layout=[
                    [
                        sg.Input(
                            size=(57, 1),
                            justification="center",
                            font=("Roboto", 12),
                            key="-INPUT_USERNAME-",
                            pad=(0, 0),
                        ),
                    ]
                ],
                size=(1575, 65),
                pad=(0, 0),
                border_width=0,
            ),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 24),
                pad=(0, 0),
            ),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(8, 0),
                pad=(0, 0),
            ),
            sg.Text(
                text="Password:",
                font=("Roboto", 12),
                pad=(0, 0),
            ),
            sg.Frame(
                title=None,
                layout=[],
                size=(47, 0),
                pad=(0, 0),
            ),
            sg.Frame(
                title=None,
                layout=[
                    [
                        sg.Input(
                            size=(57, 1),
                            password_char="●",
                            justification="center",
                            font=("Roboto", 12),
                            key="-INPUT_PASSWORD-",
                            pad=(0, 0),
                        ),
                    ]
                ],
                size=(1575, 65),
                pad=(0, 0),
                border_width=0,
            ),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 21),
                pad=(0, 0),
            ),
        ],
        [
            sg.Push(),
            sg.Button(
                button_text="User Log In [ENTER]",
                font=("Roboto", 13, "bold"),
                key="-BUTTON_USER_LOG_IN-",
            ),
            sg.Button(
                button_text="Guest Log In [PGDN]",
                font=("Roboto", 13, "bold"),
                key="-BUTTON_GUEST_LOG_IN-",
            ),
            sg.Button(
                button_text="Register [PGUP]",
                font=("Roboto", 13, "bold"),
                key="-BUTTON_REGISTER-",
            ),
            sg.Button(
                button_text="Info [END]",
                font=("Roboto", 13, "bold"),
                key="-BUTTON_INFO-",
            ),
            sg.Push(),
        ],
    ]

    window = sg.Window(
        title="SnacTrac %s - Welcome" % get_version(),
        size=(1903, 763),
        layout=layout,
        finalize=True,
        modal=True,
        enable_close_attempted_event=True,
        icon=icon_snactrac,
    )

    while True:

        event, values = window.read(timeout)

        if timeout == None and event == sg.WIN_CLOSE_ATTEMPTED_EVENT:

            play_sound("tick")

            window["-INPUT_USERNAME-"].update("")

            window["-INPUT_PASSWORD-"].update("")

            window["-INPUT_USERNAME-"].set_focus()

            if window_popup_general(
                title="Confirm Exit",
                icon="exit",
                text="Are you sure you want to exit the program?",
                button_false="Cancel",
                button_true="Confirm",
            ):

                window.close()

                return "exit", None, "user"

        if timeout == None and event == "-BUTTON_USER_LOG_IN-":

            play_sound("tick")

            if values["-INPUT_PASSWORD-"] == "":

                window["-INPUT_PASSWORD-"].update("")

                window["-INPUT_PASSWORD-"].set_focus()

                append_triggers(triggers, "-PASSWORD_BLANK-")

            if values["-INPUT_USERNAME-"].replace(" ", "") == "":

                window["-INPUT_USERNAME-"].update("")

                window["-INPUT_USERNAME-"].set_focus()

                append_triggers(triggers, "-USERNAME_BLANK-")

            if triggers == []:

                window["-INPUT_USERNAME-"].update("")

                window["-INPUT_PASSWORD-"].update("")

                window["-INPUT_USERNAME-"].set_focus()

                if authenticate_user(
                    values["-INPUT_USERNAME-"], values["-INPUT_PASSWORD-"]
                ):

                    if (
                        get_value_table(
                            "Users", "Username", values["-INPUT_USERNAME-"], "Balance"
                        )
                        < get_value_setting("Max User Debt") * -1
                    ):

                        window_popup_general(
                            title="Max Debt Exceeded",
                            text="Please pay your tab to access your account.",
                            button_true="Okay",
                        )

                    elif (
                        get_value_table(
                            "Users", "Username", values["-INPUT_USERNAME-"], "Locked"
                        )
                        == 1
                    ):

                        window_popup_general(
                            title="Account Locked",
                            text="The admin has locked your account.",
                            button_true="Okay",
                        )

                    else:

                        window.close()

                        return "store", values["-INPUT_USERNAME-"], "user"

                else:

                    window_popup_general(
                        title="Invalid Input",
                        text="The credentials entered are invalid.",
                        button_true="Okay",
                    )

            else:

                if "-USERNAME_BLANK-" in triggers:

                    window_popup_general(
                        title="Incomplete Form",
                        text="Your username must not be left blank.",
                        button_true="Okay",
                    )

                if "-PASSWORD_BLANK-" in triggers:

                    window_popup_general(
                        title="Incomplete Form",
                        text="Your password must not be left blank.",
                        button_true="Okay",
                    )

                triggers.clear()

        if timeout == None and event == "-BUTTON_GUEST_LOG_IN-":

            play_sound("tick")

            window["-INPUT_USERNAME-"].update("")

            window["-INPUT_PASSWORD-"].update("")

            window["-INPUT_USERNAME-"].set_focus()

            if get_value_setting("Guest Mode Enabled"):

                if window_popup_general(
                    title="Guest Mode Agreement",
                    icon="choice",
                    text="I agree to pay in full, immediately after buying.",
                    button_true="Agree",
                    button_false="Decline",
                ):

                    window.close()

                    return "store", None, "guest"

            else:

                window_popup_general(
                    title="Guest Mode Disabled",
                    text="Guest mode is currently disabled.",
                    button_true="Okay",
                )

        if timeout == None and event == "-BUTTON_REGISTER-":

            play_sound("tick")

            window.close()

            return "register", None, "user"

        if timeout == None and event == "-BUTTON_INFO-":

            play_sound("tick")

            window.close()

            return "info", None, "user"

        if timeout == 0:

            window.bind("<Return>", "-BUTTON_USER_LOG_IN-")

            window.bind("<Next>", "-BUTTON_GUEST_LOG_IN-")

            window.bind("<Prior>", "-BUTTON_REGISTER-")

            window.bind("<End>", "-BUTTON_INFO-")

            window["-INPUT_USERNAME-"].set_focus()

            move_window_center(window)

            timeout = None

            play_sound("pop")
