# Copyright (C) 2026 BoundWare LLC. All rights reserved.
# SnacTrac is licensed under the Apache License, Version 2.0
# See Licenses/LICENSE.txt for details.


import PySimpleGUI as sg
import re
from append_history import *
from append_notifications import *
from append_triggers import *
from asset_image_icon_snactrac import *
from clean_users import *
from clear_events import *
from convert_money import *
from delete_entry_table import *
from format_users_admin import *
from get_version import *
from get_value_table import *
from get_data_table import *
from move_window_center import *
from play_sound import *
from set_value_table import *
from window_popup_general import *


# Handle users window interaction.
def window_users():

    timeout = 0

    triggers = []

    selection = None

    query = ""

    properties = [
        "First Name",
        "Last Name",
        "Locked",
        "Balance",
        "Payment",
    ]

    property = properties[0]

    value = None

    data_users = clean_users(get_data_table("Users"))

    data_users_filtered = data_users

    layout = [
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 20),
                pad=(0, 0),
            ),
        ],
        [
            sg.Push(),
            sg.Text(
                text="USERS",
                font=("Roboto", 19, "bold"),
                pad=(0, 0),
            ),
            sg.Push(),
        ],
        [
            sg.Push(),
            sg.Text(
                text="Select a user to manage, or log in as.",
                font=("Roboto", 12, "bold"),
                pad=(0, 0),
            ),
            sg.Push(),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 16),
                pad=(0, 0),
            ),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(14, 0),
                pad=(0, 0),
            ),
            sg.Frame(
                title="Selection:",
                layout=[
                    [
                        sg.Input(
                            default_text="None",
                            size=(16, 1),
                            justification="center",
                            background_color="grey28",
                            text_color="white",
                            font=("Roboto", 12, "bold"),
                            enable_events=True,
                            key="-INPUT_SELECTION-",
                            pad=(0, 0),
                            selected_text_color="black",
                        ),
                    ],
                ],
                title_location="n",
                size=(448, 109),
                font=("Roboto", 8),
                pad=(0, 0),
                border_width=0,
            ),
            sg.Frame(
                title=None,
                layout=[],
                size=(24, 0),
                pad=(0, 0),
            ),
            sg.Frame(
                title="Search:",
                layout=[
                    [
                        sg.Input(
                            size=(16, 1),
                            justification="center",
                            font=("Roboto", 12),
                            enable_events=True,
                            key="-INPUT_SEARCH-",
                            pad=(0, 0),
                        ),
                    ],
                ],
                title_location="n",
                size=(448, 109),
                font=("Roboto", 8),
                pad=(0, 0),
                border_width=0,
            ),
            sg.Frame(
                title=None,
                layout=[],
                size=(24, 0),
                pad=(0, 0),
            ),
            sg.Frame(
                title="Property:",
                layout=[
                    [
                        sg.Combo(
                            values=properties,
                            default_value=property,
                            size=(16, 1),
                            enable_events=True,
                            key="-COMBO_PROPERTY-",
                            pad=(0, 0),
                            expand_x=False,
                            readonly=True,
                            font=("Roboto", 12),
                        ),
                    ],
                ],
                title_location="n",
                size=(446, 109),
                font=("Roboto", 8),
                pad=(0, 0),
                border_width=0,
            ),
            sg.Frame(
                title=None,
                layout=[],
                size=(24, 0),
                pad=(0, 0),
            ),
            sg.Frame(
                title="Value:",
                layout=[
                    [
                        sg.Input(
                            size=(16, 1),
                            justification="center",
                            font=("Roboto", 12),
                            key="-INPUT_VALUE-",
                            pad=(0, 0),
                        ),
                        sg.Combo(
                            values=[True, False],
                            default_value=value,
                            size=(16, 1),
                            enable_events=True,
                            key="-COMBO_VALUE-",
                            pad=(0, 0),
                            expand_x=False,
                            readonly=True,
                            font=("Roboto", 12),
                            visible=False,
                        ),
                    ],
                ],
                title_location="n",
                size=(448, 109),
                font=("Roboto", 8),
                pad=(0, 0),
                border_width=0,
            ),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 23),
                pad=(0, 0),
            ),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(14, 0),
                pad=(0, 0),
            ),
            sg.Table(
                values=format_users_admin(data_users),
                headings=[
                    "First Name",
                    "Last Name",
                    "Username",
                    "Locked",
                    "Ask Log Out",
                    "Search Mode",
                    "Balance",
                ],
                col_widths=[20, 20, 19, 16, 16, 16, 16],
                auto_size_columns=False,
                select_mode="browse",
                display_row_numbers=False,
                num_rows=13,
                font=("Roboto Mono", 6),
                justification="center",
                alternating_row_color="#465974",
                enable_events=True,
                pad=(0, 0),
                key="-TABLE_USERS-",
            ),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 21),
                pad=(0, 0),
            ),
        ],
        [
            sg.Push(),
            sg.Button(
                button_text="Go Back [ESC]",
                font=("Roboto", 13, "bold"),
                key="-BUTTON_GO_BACK-",
            ),
            sg.Button(
                button_text="Log In [END]",
                font=("Roboto", 13, "bold"),
                key="-BUTTON_LOG_IN-",
            ),
            sg.Button(
                button_text="Delete [DEL]",
                font=("Roboto", 13, "bold"),
                key="-BUTTON_DELETE-",
            ),
            sg.Button(
                button_text="Save [ENTER]",
                font=("Roboto", 13, "bold"),
                key="-BUTTON_SAVE-",
            ),
            sg.Push(),
        ],
    ]

    window = sg.Window(
        title="SnacTrac %s - Users" % get_version(),
        size=(1910, 966),
        layout=layout,
        finalize=True,
        modal=True,
        enable_close_attempted_event=True,
        icon=icon_snactrac,
    )

    while True:

        event, values = window.read(timeout)

        if timeout == None and (
            event == "-BUTTON_GO_BACK-" or event == sg.WIN_CLOSE_ATTEMPTED_EVENT
        ):

            play_sound("tick")

            window.close()

            return "admin", None, "user"

        if timeout == None and event == "-INPUT_SELECTION-":

            if selection:

                window["-INPUT_SELECTION-"].update(
                    " %s %s (%s) " % (selection[0], selection[1], selection[2])
                )

            else:

                window["-INPUT_SELECTION-"].update("None")

            window["-INPUT_SEARCH-"].set_focus()

        if timeout == None and event == "-INPUT_SEARCH-":

            if query != values["-INPUT_SEARCH-"].replace(" ", ""):

                query = values["-INPUT_SEARCH-"].lower().replace(" ", "")

                data_users_filtered = [
                    user
                    for user in data_users
                    if query in user[0].lower().replace(" ", "")
                    or query in user[1].lower().replace(" ", "")
                    or query in user[2].lower()
                ]

                window["-TABLE_USERS-"].update(format_users_admin(data_users_filtered))

                if len(data_users_filtered) == 1:

                    window["-TABLE_USERS-"].update(select_rows=[0])

        if timeout == None and event == "-TABLE_USERS-":

            if values["-TABLE_USERS-"]:

                if selection != data_users_filtered[values["-TABLE_USERS-"][0]]:

                    play_sound("click")

                    selection = data_users_filtered[values["-TABLE_USERS-"][0]]

                    window["-INPUT_SELECTION-"].update(
                        value=" %s %s (%s) "
                        % (selection[0], selection[1], selection[2]),
                        background_color="#65b946",
                    )

                else:

                    play_sound("nope")

                clear_events(window)

            else:

                play_sound("scrape")

                selection = None

                window["-INPUT_SELECTION-"].update(
                    value="None", background_color="grey28"
                )

                window["-INPUT_VALUE-"].update("")

                value = None

                window["-COMBO_VALUE-"].update("")

            if selection:

                if values["-COMBO_PROPERTY-"] == "First Name":

                    window["-INPUT_VALUE-"].update(selection[0])

                elif values["-COMBO_PROPERTY-"] == "Last Name":

                    window["-INPUT_VALUE-"].update(selection[1])

                elif values["-COMBO_PROPERTY-"] == "Locked":

                    value = selection[3]

                    window["-COMBO_VALUE-"].update(value)

                elif values["-COMBO_PROPERTY-"] == "Balance":

                    window["-INPUT_VALUE-"].update(convert_money(selection[6]))

                elif values["-COMBO_PROPERTY-"] == "Payment":

                    window["-INPUT_VALUE-"].update("")

            window["-INPUT_SEARCH-"].set_focus()

        if timeout == None and event == "-COMBO_PROPERTY-":

            if property != values["-COMBO_PROPERTY-"]:

                play_sound("tick")

                property = values["-COMBO_PROPERTY-"]

            else:

                play_sound("nope")

            if values["-COMBO_PROPERTY-"] == "Locked":

                window["-INPUT_VALUE-"].update(visible=False)

                window["-COMBO_VALUE-"].update(visible=True)

            else:

                window["-COMBO_VALUE-"].update(visible=False)

                window["-INPUT_VALUE-"].update(visible=True)

            window["-INPUT_VALUE-"].update("")

            value = None

            window["-COMBO_VALUE-"].update("")

            if selection:

                if values["-COMBO_PROPERTY-"] == "First Name":

                    window["-INPUT_VALUE-"].update(selection[0])

                elif values["-COMBO_PROPERTY-"] == "Last Name":

                    window["-INPUT_VALUE-"].update(selection[1])

                elif values["-COMBO_PROPERTY-"] == "Locked":

                    value = selection[3]

                    window["-COMBO_VALUE-"].update(value)

                elif values["-COMBO_PROPERTY-"] == "Balance":

                    window["-INPUT_VALUE-"].update(convert_money(selection[6]))

                elif values["-COMBO_PROPERTY-"] == "Payment":

                    window["-INPUT_VALUE-"].update("")

            window["-INPUT_SEARCH-"].set_focus()

            window["-COMBO_PROPERTY-"].Widget.select_range(0, 0)

        if timeout == None and event == "-COMBO_VALUE-":

            if value != values["-COMBO_VALUE-"]:

                play_sound("tick")

                value = values["-COMBO_VALUE-"]

            else:

                play_sound("nope")

            window["-INPUT_SEARCH-"].set_focus()

            window["-COMBO_VALUE-"].Widget.select_range(0, 0)

        if timeout == None and event == "-BUTTON_LOG_IN-":

            play_sound("tick")

            if selection:

                window.close()

                return "store", selection[2], "admin"

            else:

                window_popup_general(
                    title="Missing Selection",
                    text="A user must be selected to log in.",
                    button_true="Okay",
                )

        if timeout == None and event == "-BUTTON_DELETE-":

            play_sound("tick")

            if selection:

                if window_popup_general(
                    title="Confirm Delete User",
                    icon="choice",
                    text="Delete the selected user?",
                    button_true="Confirm",
                    button_false="Cancel",
                ):

                    query = ""

                    window["-INPUT_SEARCH-"].update(query)

                    delete_entry_table("Users", "Username", selection[2])

                    selection = None

                    window["-INPUT_SELECTION-"].update(
                        value="None", background_color="grey28"
                    )

                    window["-INPUT_VALUE-"].update("")

                    value = None

                    window["-COMBO_VALUE-"].update("")

                    data_users = clean_users(get_data_table("Users"))

                    data_users_filtered = data_users

                    window["-TABLE_USERS-"].update(
                        format_users_admin(data_users_filtered)
                    )

                    clear_events(window)

                    window_popup_general(
                        title="User Deleted",
                        icon="success",
                        text="The selected user has been deleted.",
                        button_true="Okay",
                    )

            else:

                window_popup_general(
                    title="Missing Selection",
                    text="A user must be selected to delete.",
                    button_true="Okay",
                )

            window["-INPUT_SEARCH-"].set_focus()

        if timeout == None and event == "-BUTTON_SAVE-":

            play_sound("tick")

            if selection:

                window["-TABLE_USERS-"].Widget.yview_moveto(
                    values["-TABLE_USERS-"][0] / len(data_users_filtered)
                )

                if values["-COMBO_PROPERTY-"] == "First Name":

                    if selection[0] == values["-INPUT_VALUE-"]:

                        window["-INPUT_VALUE-"].update(selection[0])

                        window["-INPUT_VALUE-"].Widget.select_range(0, sg.tk.END)

                        append_triggers(triggers, "-FIRST_NAME_SAME-")

                    elif values["-INPUT_VALUE-"].replace(" ", "") == "":

                        window["-INPUT_VALUE-"].update(selection[0])

                        window["-INPUT_VALUE-"].Widget.select_range(0, sg.tk.END)

                        append_triggers(triggers, "-FIRST_NAME_BLANK-")

                    elif (
                        values["-INPUT_VALUE-"]
                        != re.sub(r"\s{2,}", " ", values["-INPUT_VALUE-"]).strip()
                    ):

                        window["-INPUT_VALUE-"].update(selection[0])

                        window["-INPUT_VALUE-"].Widget.select_range(0, sg.tk.END)

                        append_triggers(triggers, "-FIRST_NAME_SPACE-")

                    else:

                        if window_popup_general(
                            title="Confirm User Property",
                            icon="choice",
                            text='Set the selected user\'s first name to "%s"?'
                            % values["-INPUT_VALUE-"],
                            button_false="Cancel",
                            button_true="Confirm",
                        ):

                            window["-INPUT_VALUE-"].update(values["-INPUT_VALUE-"])

                            set_value_table(
                                "Users",
                                "Username",
                                selection[2],
                                "First Name",
                                values["-INPUT_VALUE-"],
                            )

                            append_triggers(triggers, "-FIRST_NAME_CHANGED-")

                        else:

                            window["-INPUT_VALUE-"].update(selection[0])

                            window["-INPUT_VALUE-"].Widget.select_range(0, sg.tk.END)

                elif values["-COMBO_PROPERTY-"] == "Last Name":

                    if selection[1] == values["-INPUT_VALUE-"]:

                        window["-INPUT_VALUE-"].update(selection[1])

                        window["-INPUT_VALUE-"].Widget.select_range(0, sg.tk.END)

                        append_triggers(triggers, "-LAST_NAME_SAME-")

                    elif values["-INPUT_VALUE-"].replace(" ", "") == "":

                        window["-INPUT_VALUE-"].update(selection[1])

                        window["-INPUT_VALUE-"].Widget.select_range(0, sg.tk.END)

                        append_triggers(triggers, "-LAST_NAME_BLANK-")

                    elif (
                        values["-INPUT_VALUE-"]
                        != re.sub(r"\s{2,}", " ", values["-INPUT_VALUE-"]).strip()
                    ):

                        window["-INPUT_VALUE-"].update(selection[1])

                        window["-INPUT_VALUE-"].Widget.select_range(0, sg.tk.END)

                        append_triggers(triggers, "-LAST_NAME_SPACE-")

                    else:

                        if window_popup_general(
                            title="Confirm User Property",
                            icon="choice",
                            text='Set the selected user\'s last name to "%s"?'
                            % values["-INPUT_VALUE-"],
                            button_false="Cancel",
                            button_true="Confirm",
                        ):

                            window["-INPUT_VALUE-"].update(values["-INPUT_VALUE-"])

                            set_value_table(
                                "Users",
                                "Username",
                                selection[2],
                                "Last Name",
                                values["-INPUT_VALUE-"],
                            )

                            append_triggers(triggers, "-LAST_NAME_CHANGED-")

                        else:

                            window["-INPUT_VALUE-"].update(selection[1])

                            window["-INPUT_VALUE-"].Widget.select_range(0, sg.tk.END)

                elif values["-COMBO_PROPERTY-"] == "Locked":

                    if selection[3] == values["-COMBO_VALUE-"]:

                        window["-COMBO_VALUE-"].set_focus()

                        append_triggers(triggers, "-LOCKED_SAME-")

                    else:

                        if window_popup_general(
                            title="Confirm User Property",
                            icon="choice",
                            text='Set the selected user\'s locked status to "%s"?'
                            % values["-COMBO_VALUE-"],
                            button_false="Cancel",
                            button_true="Confirm",
                        ):

                            set_value_table(
                                "Users",
                                "Username",
                                selection[2],
                                "Locked",
                                int(values["-COMBO_VALUE-"]),
                            )

                            append_triggers(triggers, "-LOCKED_CHANGED-")

                        else:

                            value = selection[3]

                            window["-COMBO_VALUE-"].update(value)

                            window["-COMBO_VALUE-"].set_focus()

                elif values["-COMBO_PROPERTY-"] == "Balance":

                    try:

                        money = convert_money(values["-INPUT_VALUE-"])

                        if money == selection[6]:

                            window["-INPUT_VALUE-"].update(convert_money(selection[6]))

                            window["-INPUT_VALUE-"].Widget.select_range(0, sg.tk.END)

                            append_triggers(triggers, "-BALANCE_SAME-")

                        else:

                            window["-INPUT_VALUE-"].update(convert_money(money))

                            if window_popup_general(
                                title="Confirm User Property",
                                icon="choice",
                                text="Set the selected user's balance to %s?"
                                % convert_money(money),
                                button_false="Cancel",
                                button_true="Confirm",
                            ):

                                set_value_table(
                                    "Users",
                                    "Username",
                                    selection[2],
                                    "Balance",
                                    money,
                                )

                                append_notifications(selection[2], 0, money)

                                append_triggers(triggers, "-BALANCE_CHANGED-")

                            else:

                                window["-INPUT_VALUE-"].update(
                                    convert_money(selection[6])
                                )

                                window["-INPUT_VALUE-"].Widget.select_range(
                                    0, sg.tk.END
                                )

                    except:

                        if values["-INPUT_VALUE-"].replace(" ", "") == "":

                            append_triggers(triggers, "-BALANCE_BLANK-")

                        else:

                            append_triggers(triggers, "-BALANCE_INVALID-")

                        window["-INPUT_VALUE-"].update(convert_money(selection[6]))

                        window["-INPUT_VALUE-"].Widget.select_range(0, sg.tk.END)

                elif values["-COMBO_PROPERTY-"] == "Payment":

                    try:

                        money = convert_money(values["-INPUT_VALUE-"])

                        if money > 0:

                            window["-INPUT_VALUE-"].update(convert_money(money))

                            if window_popup_general(
                                title="Confirm Payment",
                                icon="choice",
                                text="Add %s to the selected user's balance?"
                                % convert_money(money),
                                button_false="Cancel",
                                button_true="Confirm",
                            ):

                                set_value_table(
                                    "Users",
                                    "Username",
                                    selection[2],
                                    "Balance",
                                    selection[6] + money,
                                )

                                append_history(
                                    user="%s %s (%s)"
                                    % (
                                        selection[0],
                                        selection[1],
                                        selection[2],
                                    ),
                                    mode="Admin",
                                    action="Payment",
                                    description="%s added" % convert_money(money),
                                    total=money,
                                    balance_old=selection[6],
                                    balance_new=selection[6] + money,
                                )

                                window["-INPUT_VALUE-"].update("")

                                append_notifications(selection[2], 1, money)

                                append_triggers(triggers, "-PAYMENT_ACCEPTED-")

                        else:

                            window["-INPUT_VALUE-"].update("")

                            append_triggers(triggers, "-PAYMENT_LOW-")

                    except:

                        if values["-INPUT_VALUE-"].replace(" ", "") == "":

                            append_triggers(triggers, "-PAYMENT_BLANK-")

                        else:

                            append_triggers(triggers, "-PAYMENT_INVALID-")

                        window["-INPUT_VALUE-"].update("")

                window["-INPUT_VALUE-"].set_focus()

                data_users = clean_users(get_data_table("Users"))

                data_users_filtered = [
                    user
                    for user in data_users
                    if query.lower() in user[0].lower().replace(" ", "")
                    or query.lower() in user[1].lower().replace(" ", "")
                    or query.lower() in user[2].lower()
                ]

                index = [user[2] for user in data_users_filtered].index(selection[2])

                selection = data_users_filtered[index]

                window["-INPUT_SELECTION-"].update(
                    value=" %s %s (%s) " % (selection[0], selection[1], selection[2])
                )

                window["-TABLE_USERS-"].update(format_users_admin(data_users_filtered))

                window["-TABLE_USERS-"].update(select_rows=[index])

                window["-TABLE_USERS-"].Widget.yview_moveto(
                    index / len(data_users_filtered)
                )

                clear_events(window)

            else:

                window_popup_general(
                    title="Missing Selection",
                    text="A user must be selected to save.",
                    button_true="Okay",
                )

            if triggers:

                if "-FIRST_NAME_SAME-" in triggers:

                    window_popup_general(
                        title="Invalid Input",
                        text="The first name entered is already in use.",
                        button_true="Okay",
                    )

                if "-FIRST_NAME_BLANK-" in triggers:

                    window_popup_general(
                        title="Incomplete Form",
                        text="The first name must not be left blank.",
                        button_true="Okay",
                    )

                if "-FIRST_NAME_SPACE-" in triggers:

                    window_popup_general(
                        title="Invalid Input",
                        text="The first name must not contain excessive spaces.",
                        button_true="Okay",
                    )

                if "-FIRST_NAME_CHANGED-" in triggers:

                    window_popup_general(
                        title="User Property Set",
                        icon="success",
                        text='The selected user\'s first name has been set to "%s".'
                        % values["-INPUT_VALUE-"],
                        button_true="Okay",
                    )

                if "-LAST_NAME_SAME-" in triggers:

                    window_popup_general(
                        title="Invalid Input",
                        text="The last name entered is already in use.",
                        button_true="Okay",
                    )

                if "-LAST_NAME_BLANK-" in triggers:

                    window_popup_general(
                        title="Incomplete Form",
                        text="The last name must not be left blank.",
                        button_true="Okay",
                    )

                if "-LAST_NAME_SPACE-" in triggers:

                    window_popup_general(
                        title="Invalid Input",
                        text="The last name must not contain excessive spaces.",
                        button_true="Okay",
                    )

                if "-LAST_NAME_CHANGED-" in triggers:

                    window_popup_general(
                        title="User Property Set",
                        icon="success",
                        text='The selected user\'s last name has been set to "%s".'
                        % values["-INPUT_VALUE-"],
                        button_true="Okay",
                    )

                if "-LOCKED_SAME-" in triggers:

                    window_popup_general(
                        title="Invalid Input",
                        text="The locked status selected is already in use.",
                        button_true="Okay",
                    )

                if "-LOCKED_CHANGED-" in triggers:

                    window_popup_general(
                        title="User Property Set",
                        icon="success",
                        text='The selected user\'s locked status has been set to "%s".'
                        % values["-COMBO_VALUE-"],
                        button_true="Okay",
                    )

                if "-BALANCE_SAME-" in triggers:

                    window_popup_general(
                        title="Invalid Input",
                        text="The balance entered is already in use.",
                        button_true="Okay",
                    )

                if "-BALANCE_BLANK-" in triggers:

                    window_popup_general(
                        title="Incomplete Form",
                        text="The balance must not be left blank.",
                        button_true="Okay",
                    )

                if "-BALANCE_INVALID-" in triggers:

                    window_popup_general(
                        title="Invalid Input",
                        text="The balance must be a dollar amount.",
                        button_true="Okay",
                    )

                if "-BALANCE_CHANGED-" in triggers:

                    window_popup_general(
                        title="User Property Set",
                        icon="success",
                        text="The selected user's balance has been set to %s."
                        % convert_money(money),
                        button_true="Okay",
                    )

                if "-PAYMENT_BLANK-" in triggers:

                    window_popup_general(
                        title="Incomplete Form",
                        text="The payment must not be left blank.",
                        button_true="Okay",
                    )

                if "-PAYMENT_INVALID-" in triggers:

                    window_popup_general(
                        title="Invalid Input",
                        text="The payment must be a dollar amount.",
                        button_true="Okay",
                    )

                if "-PAYMENT_LOW-" in triggers:

                    window_popup_general(
                        title="Invalid Input",
                        text="The payment must be above zero.",
                        button_true="Okay",
                    )

                if "-PAYMENT_ACCEPTED-" in triggers:

                    window_popup_general(
                        title="Payment Accepted",
                        icon="success",
                        text="%s was added to the selected user's balance."
                        % convert_money(money),
                        button_true="Okay",
                    )

            triggers.clear()

        if timeout == 0:

            window.bind("<Escape>", "-BUTTON_GO_BACK-")

            window.bind("<End>", "-BUTTON_LOG_IN-")

            window.bind("<Delete>", "-BUTTON_DELETE-")

            window.bind("<Return>", "-BUTTON_SAVE-")

            window["-COMBO_PROPERTY-"].Widget.configure(justify="center")

            window["-COMBO_VALUE-"].Widget.configure(justify="center")

            window["-INPUT_SEARCH-"].set_focus()

            move_window_center(window)

            timeout = None

            play_sound("pop")
