# Copyright (C) 2026 BoundWare LLC. All rights reserved.
# SnacTrac is licensed under the Apache License, Version 2.0
# See Licenses/LICENSE.txt for details.


import PySimpleGUI as sg
from asset_image_icon_info import *
from asset_image_icon_snactrac import *
from convert_money import *
from get_version import *
from get_stat_credit import *
from get_stat_debt import *
from get_stat_profit import *
from move_window_center import *
from play_sound import *
from window_popup_general import *


# Handle stats window interaction.
def window_stats():

    timeout = 0

    total_money = None

    customer_credit = get_stat_credit()

    customer_debt = get_stat_debt()

    estimated_profit = get_stat_profit()

    vendor_money = None

    if customer_credit > 0:

        customer_credit_color = "#65b946"

    else:

        customer_credit_color = "grey28"

    if customer_debt > 0:

        customer_debt_color = "#b94646"

    else:

        customer_debt_color = "grey28"

    if estimated_profit > 0:

        estimated_profit_color = "#65b946"

    elif estimated_profit < 0:

        estimated_profit_color = "#b94646"

    else:

        estimated_profit_color = "grey28"

    vendor_money_color = "grey28"

    layout = [
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 20),
                pad=(0, 0),
            ),
        ],
        [
            sg.Push(),
            sg.Text(
                text="STATS",
                font=("Roboto", 19, "bold"),
                pad=(0, 0),
            ),
            sg.Push(),
        ],
        [
            sg.Push(),
            sg.Text(
                text="Enter total money held to calculate.",
                font=("Roboto", 12, "bold"),
                pad=(0, 0),
            ),
            sg.Push(),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 31),
                pad=(0, 0),
            ),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(12, 0),
                pad=(0, 0),
            ),
            sg.Text(
                text="Total Money:",
                font=("Roboto", 12),
                pad=(0, 0),
            ),
            sg.Frame(
                title=None,
                layout=[],
                size=(141, 0),
                pad=(0, 0),
            ),
            sg.Image(
                source=icon_info,
                pad=(5, 0),
                tooltip="Total money held.",
            ),
            sg.Frame(
                title=None,
                layout=[],
                size=(7, 0),
                pad=(0, 0),
            ),
            sg.Frame(
                title=None,
                layout=[
                    [
                        sg.Input(
                            size=(15, 1),
                            justification="center",
                            font=("Roboto", 12),
                            key="-INPUT_TOTAL_MONEY-",
                            pad=(0, 0),
                        ),
                    ]
                ],
                size=(405, 65),
                pad=(0, 0),
                border_width=0,
            ),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 24),
                pad=(0, 0),
            ),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(10, 0),
                pad=(0, 0),
            ),
            sg.Text(
                text="Customer Credit:",
                font=("Roboto", 12),
                pad=(0, 0),
            ),
            sg.Frame(
                title=None,
                layout=[],
                size=(57, 0),
                pad=(0, 0),
            ),
            sg.Image(
                source=icon_info,
                pad=(5, 0),
                tooltip="Customers' combined credit.",
            ),
            sg.Frame(
                title=None,
                layout=[],
                size=(7, 0),
                pad=(0, 0),
            ),
            sg.Frame(
                title=None,
                layout=[
                    [
                        sg.Input(
                            default_text=convert_money(customer_credit),
                            size=(14, 1),
                            justification="center",
                            background_color=customer_credit_color,
                            text_color="white",
                            font=("Roboto", 12, "bold"),
                            enable_events=True,
                            key="-INPUT_CUSTOMER_CREDIT-",
                            pad=(0, 0),
                            selected_text_color="black",
                        ),
                    ]
                ],
                size=(405, 65),
                pad=(0, 0),
                border_width=0,
            ),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 24),
                pad=(0, 0),
            ),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(10, 0),
                pad=(0, 0),
            ),
            sg.Text(
                text="Customer Debt:",
                font=("Roboto", 12),
                pad=(0, 0),
            ),
            sg.Frame(
                title=None,
                layout=[],
                size=(86, 0),
                pad=(0, 0),
            ),
            sg.Image(
                source=icon_info,
                pad=(5, 0),
                tooltip="Customers' combined debt.",
            ),
            sg.Frame(
                title=None,
                layout=[],
                size=(7, 0),
                pad=(0, 0),
            ),
            sg.Frame(
                title=None,
                layout=[
                    [
                        sg.Input(
                            default_text=convert_money(customer_debt),
                            size=(14, 1),
                            justification="center",
                            background_color=customer_debt_color,
                            text_color="white",
                            font=("Roboto", 12, "bold"),
                            enable_events=True,
                            key="-INPUT_CUSTOMER_DEBT-",
                            pad=(0, 0),
                            selected_text_color="black",
                        ),
                    ]
                ],
                size=(405, 65),
                pad=(0, 0),
                border_width=0,
            ),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 24),
                pad=(0, 0),
            ),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(9, 0),
                pad=(0, 0),
            ),
            sg.Text(
                text="Estimated Profit:",
                font=("Roboto", 12),
                pad=(0, 0),
            ),
            sg.Frame(
                title=None,
                layout=[],
                size=(63, 0),
                pad=(0, 0),
            ),
            sg.Image(
                source=icon_info,
                pad=(5, 0),
                tooltip="Summed from history only.",
            ),
            sg.Frame(
                title=None,
                layout=[],
                size=(7, 0),
                pad=(0, 0),
            ),
            sg.Frame(
                title=None,
                layout=[
                    [
                        sg.Input(
                            default_text=convert_money(estimated_profit),
                            size=(14, 1),
                            justification="center",
                            background_color=estimated_profit_color,
                            text_color="white",
                            font=("Roboto", 12, "bold"),
                            enable_events=True,
                            key="-INPUT_ESTIMATED_PROFIT-",
                            pad=(0, 0),
                            selected_text_color="black",
                        ),
                    ]
                ],
                size=(405, 65),
                pad=(0, 0),
                border_width=0,
            ),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 24),
                pad=(0, 0),
            ),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(12, 0),
                pad=(0, 0),
            ),
            sg.Text(
                text="Vendor Money:",
                font=("Roboto", 12),
                pad=(0, 0),
            ),
            sg.Frame(
                title=None,
                layout=[],
                size=(95, 0),
                pad=(0, 0),
            ),
            sg.Image(
                source=icon_info,
                pad=(5, 0),
                tooltip="Spendable money.",
            ),
            sg.Frame(
                title=None,
                layout=[],
                size=(7, 0),
                pad=(0, 0),
            ),
            sg.Frame(
                title=None,
                layout=[
                    [
                        sg.Input(
                            default_text="?",
                            size=(14, 1),
                            justification="center",
                            background_color=vendor_money_color,
                            text_color="white",
                            font=("Roboto", 12, "bold"),
                            enable_events=True,
                            key="-INPUT_VENDOR_MONEY-",
                            pad=(0, 0),
                            selected_text_color="black",
                        ),
                    ]
                ],
                size=(405, 65),
                pad=(0, 0),
                border_width=0,
            ),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 21),
                pad=(0, 0),
            ),
        ],
        [
            sg.Push(),
            sg.Button(
                button_text="Go Back [ESC]",
                font=("Roboto", 13, "bold"),
                key="-BUTTON_GO_BACK-",
            ),
            sg.Button(
                button_text="Calculate [ENTER]",
                font=("Roboto", 13, "bold"),
                key="-BUTTON_CALCULATE-",
            ),
            sg.Push(),
        ],
    ]

    window = sg.Window(
        title="SnacTrac %s - Stats" % get_version(),
        size=(946, 804),
        layout=layout,
        finalize=True,
        modal=True,
        enable_close_attempted_event=True,
        icon=icon_snactrac,
    )

    while True:

        event, values = window.read(timeout)

        if timeout == None and (
            event == "-BUTTON_GO_BACK-" or event == sg.WIN_CLOSE_ATTEMPTED_EVENT
        ):

            play_sound("tick")

            window.close()

            return "admin"

        if timeout == None and event == "-INPUT_CUSTOMER_CREDIT-":

            window["-INPUT_CUSTOMER_CREDIT-"].update(convert_money(customer_credit))

            window["-INPUT_TOTAL_MONEY-"].set_focus()

        if timeout == None and event == "-INPUT_CUSTOMER_DEBT-":

            window["-INPUT_CUSTOMER_DEBT-"].update(convert_money(customer_debt))

            window["-INPUT_TOTAL_MONEY-"].set_focus()

        if timeout == None and event == "-INPUT_ESTIMATED_PROFIT-":

            window["-INPUT_ESTIMATED_PROFIT-"].update(convert_money(estimated_profit))

            window["-INPUT_TOTAL_MONEY-"].set_focus()

        if timeout == None and event == "-INPUT_VENDOR_MONEY-":

            if vendor_money == None:

                window["-INPUT_VENDOR_MONEY-"].update("?")

            else:

                window["-INPUT_VENDOR_MONEY-"].update(convert_money(vendor_money))

            window["-INPUT_TOTAL_MONEY-"].set_focus()

        if timeout == None and event == "-BUTTON_CALCULATE-":

            play_sound("tick")

            if values["-INPUT_TOTAL_MONEY-"].replace(" ", "") == "":

                window["-INPUT_TOTAL_MONEY-"].update("")

                window["-INPUT_TOTAL_MONEY-"].set_focus()

                window["-INPUT_VENDOR_MONEY-"].update(
                    value="?", background_color="grey28"
                )

                window_popup_general(
                    title="Incomplete Form",
                    text="The total money must not be left blank.",
                    button_true="Okay",
                )

            else:

                try:

                    if total_money == convert_money(values["-INPUT_TOTAL_MONEY-"]):

                        window["-INPUT_TOTAL_MONEY-"].update(convert_money(total_money))

                        window["-INPUT_TOTAL_MONEY-"].set_focus()

                        window["-INPUT_TOTAL_MONEY-"].Widget.select_range(0, sg.tk.END)

                        window_popup_general(
                            title="No Change",
                            text="No changes have been made to total money.",
                            button_true="Okay",
                        )

                    else:

                        total_money = convert_money(values["-INPUT_TOTAL_MONEY-"])

                        window["-INPUT_TOTAL_MONEY-"].update(convert_money(total_money))

                        window["-INPUT_TOTAL_MONEY-"].set_focus()

                        window["-INPUT_TOTAL_MONEY-"].Widget.select_range(0, sg.tk.END)

                        vendor_money = total_money - (customer_credit + customer_debt)

                        if vendor_money > 0:

                            vendor_money_color = "#65b946"

                        elif vendor_money < 0:

                            vendor_money_color = "#b94646"

                        else:

                            vendor_money_color = "grey28"

                        window["-INPUT_VENDOR_MONEY-"].update(
                            value=convert_money(vendor_money),
                            background_color=vendor_money_color,
                        )

                except:

                    total_money = None

                    vendor_money = None

                    window["-INPUT_TOTAL_MONEY-"].update("")

                    window["-INPUT_TOTAL_MONEY-"].set_focus()

                    window["-INPUT_VENDOR_MONEY-"].update(
                        value="?", background_color="grey28"
                    )

                    window_popup_general(
                        title="Invalid Input",
                        text="The total money must be a dollar amount.",
                        button_true="Okay",
                    )

        if timeout == 0:

            window.bind("<Escape>", "-BUTTON_GO_BACK-")

            window.bind("<Return>", "-BUTTON_CALCULATE-")

            window["-INPUT_TOTAL_MONEY-"].set_focus()

            move_window_center(window)

            timeout = None

            play_sound("pop")
