# Copyright (C) 2026 BoundWare LLC. All rights reserved.
# SnacTrac is licensed under the Apache License, Version 2.0
# See Licenses/LICENSE.txt for details.


import PySimpleGUI as sg
from asset_image_icon_snactrac import *
from append_triggers import *
from get_version import *
from move_window_center import *
from play_sound import *
from window_popup_general import *
from get_onboarding_1 import *
from get_onboarding_2 import *
from get_onboarding_3 import *
from get_onboarding_4 import *


# Handle initial onboarding window interaction.
def window_program_setup_wizard():

    timeout = 0

    step = 1

    triggers = []

    layout = [
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 20),
                pad=(0, 0),
            ),
        ],
        [
            sg.Push(),
            sg.Text(
                text="PROGRAM SETUP WIZARD",
                font=("Roboto", 19, "bold"),
                pad=(0, 0),
            ),
            sg.Push(),
        ],
        [
            sg.Push(),
            sg.Text(
                text="Welcome to SnacTrac!",
                font=("Roboto", 12, "bold"),
                pad=(0, 0),
            ),
            sg.Push(),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 31),
                pad=(0, 0),
            ),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(14, 0),
                pad=(0, 0),
            ),
            sg.Multiline(
                default_text=get_onboarding_1(),
                disabled=True,
                size=(66, 10),
                text_color="#9B9B9B",
                key="-TEXT_PROGRAM_SETUP_WIZARD-",
                font=("Roboto Mono", 7),
                pad=(0, 0),
            ),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 21),
                pad=(0, 0),
            ),
        ],
        [
            sg.Push(),
            sg.Button(
                button_text="Exit [ESC]",
                font=("Roboto", 13, "bold"),
                key="-BUTTON_EXIT-",
            ),
            sg.Button(
                button_text="Next [ENTER]",
                font=("Roboto", 13, "bold"),
                key="-BUTTON_NEXT-",
            ),
            sg.Push(),
        ],
    ]

    window = sg.Window(
        title="SnacTrac %s - Program Setup Wizard" % get_version(),
        size=(1189, 767),
        layout=layout,
        finalize=True,
        modal=True,
        enable_close_attempted_event=True,
        icon=icon_snactrac,
    )

    while True:

        event, values = window.read(timeout)

        if timeout == None and (
            event == "-BUTTON_EXIT-" or event == sg.WIN_CLOSE_ATTEMPTED_EVENT
        ):

            play_sound("tick")

            append_triggers(triggers, "-BACK-")

        if timeout == None and event == "-BUTTON_NEXT-":

            play_sound("tick")

            append_triggers(triggers, "-NEXT-")

        if triggers:

            if "-BACK-" in triggers:

                if step == 1:

                    if window_popup_general(
                        title="Confirm Exit",
                        icon="exit",
                        text="Are you sure you want to exit the program?",
                        button_false="Cancel",
                        button_true="Confirm",
                    ):

                        window.close()

                        return False
                
                else:

                    step -= 1
            
            if "-NEXT-" in triggers:

                if step == 4:

                    if window_popup_general(
                        title="Confirm Setup",
                        icon="choice",
                        text="It is critical you understand these instructions. Are you ready to complete the setup?",
                        button_false="Cancel",
                        button_true="Confirm",
                    ):

                        window.close()

                        return True
                
                else:

                    step += 1

            if step == 1:

                window["-TEXT_PROGRAM_SETUP_WIZARD-"].update(get_onboarding_1())

                window["-BUTTON_EXIT-"].update("Exit [ESC]")

                window["-BUTTON_NEXT-"].update("Next [ENTER]")

            elif step == 2:

                window["-TEXT_PROGRAM_SETUP_WIZARD-"].update(get_onboarding_2())

                window["-BUTTON_EXIT-"].update("Go Back [ESC]")

                window["-BUTTON_NEXT-"].update("Agree [ENTER]")

            elif step == 3:

                window["-TEXT_PROGRAM_SETUP_WIZARD-"].update(get_onboarding_3())

                window["-BUTTON_EXIT-"].update("Go Back [ESC]")

                window["-BUTTON_NEXT-"].update("Next [ENTER]")

            elif step == 4:

                window["-TEXT_PROGRAM_SETUP_WIZARD-"].update(get_onboarding_4())

                window["-BUTTON_EXIT-"].update("Go Back [ESC]")

                window["-BUTTON_NEXT-"].update("Complete Setup [ENTER]")


        triggers.clear()

        if timeout == 0:

            window.bind("<Escape>", "-BUTTON_EXIT-")

            window.bind("<Return>", "-BUTTON_NEXT-")

            move_window_center(window)

            timeout = None

            play_sound("pop")
