# Copyright (C) 2026 BoundWare LLC. All rights reserved.
# SnacTrac is licensed under the Apache License, Version 2.0
# See Licenses/LICENSE.txt for details.


import PySimpleGUI as sg
from asset_image_icon_choice import *
from asset_image_icon_snactrac import *
from convert_money import *
from move_window_center import *
from play_sound import *


# Handle purchase popup window interaction.
def window_popup_purchase(name, stock, price):

    timeout = 0

    quantity = 1

    layout = [
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 19),
                pad=(0, 0),
            ),
        ],
        [
            sg.Push(),
            sg.Image(
                source=icon_choice,
                pad=(0, 0),
            ),
            sg.Push(),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 22),
                pad=(0, 0),
            ),
        ],
        [
            sg.Push(),
            sg.Frame(
                title=None,
                layout=[],
                size=(4, 0),
                pad=(0, 0),
            ),
            sg.Text(
                text='Purchase x %s "%s" for %s?'
                % (
                    quantity,
                    name,
                    convert_money(price),
                ),
                font=("Roboto", 12),
                pad=(0, 0),
                key="-TEXT_DETAILS-",
            ),
            sg.Frame(
                title=None,
                layout=[],
                size=(6, 0),
                pad=(0, 0),
            ),
            sg.Push(),
        ],
        [
            sg.Push(),
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 28),
                pad=(0, 0),
                border_width=0,
            ),
            sg.Push(),
        ],
        [
            sg.Push(),
            sg.Frame(
                title=None,
                layout=[],
                size=(5, 0),
                pad=(0, 0),
            ),
            sg.Button(
                button_text="Cancel [ESC]",
                font=("Roboto", 13, "bold"),
                key="-BUTTON_CANCEL-",
            ),
            sg.Button(
                button_text="Decrease [DN]",
                font=("Roboto", 13, "bold"),
                key="-BUTTON_DECREASE-",
            ),
            sg.Button(
                button_text="Increase [UP]",
                font=("Roboto", 13, "bold"),
                key="-BUTTON_INCREASE-",
            ),
            sg.Button(
                button_text="Confirm [ENTER]",
                font=("Roboto", 13, "bold"),
                key="-BUTTON_CONFIRM-",
            ),
            sg.Frame(
                title=None,
                layout=[],
                size=(5, 0),
                pad=(0, 0),
            ),
            sg.Push(),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 16),
                pad=(0, 0),
            ),
        ],
    ]

    window = sg.Window(
        title="Confirm Purchase",
        layout=layout,
        finalize=True,
        modal=True,
        enable_close_attempted_event=True,
        icon=icon_snactrac,
    )

    while True:

        event, values = window.read(timeout)

        if timeout == None and (
            event == "-BUTTON_CANCEL-" or event == sg.WIN_CLOSE_ATTEMPTED_EVENT
        ):

            play_sound("tick")

            window.close()

            return False

        if timeout == None and event == "-BUTTON_DECREASE-":

            play_sound("tick")

            if quantity - 1 < 1:

                quantity = stock

            else:

                quantity -= 1

            window["-TEXT_DETAILS-"].update(
                'Purchase x %s "%s" for %s?'
                % (quantity, name, convert_money(price * quantity))
            )

        if timeout == None and event == "-BUTTON_INCREASE-":

            play_sound("tick")

            if quantity + 1 > stock:

                quantity = 1

            else:

                quantity += 1

            window["-TEXT_DETAILS-"].update(
                'Purchase x %s "%s" for %s?'
                % (quantity, name, convert_money(price * quantity))
            )

        if timeout == None and event == "-BUTTON_CONFIRM-":

            play_sound("tick")

            window.close()

            return quantity

        if timeout == 0:

            window.bind("<Escape>", "-BUTTON_CANCEL-")

            window.bind("<Down>", "-BUTTON_DECREASE-")

            window.bind("<Up>", "-BUTTON_INCREASE-")

            window.bind("<Return>", "-BUTTON_CONFIRM-")

            move_window_center(window)

            timeout = None

            play_sound("pop")
