# Copyright (C) 2026 BoundWare LLC. All rights reserved.
# SnacTrac is licensed under the Apache License, Version 2.0
# See Licenses/LICENSE.txt for details.


import PySimpleGUI as sg
from asset_image_icon_exit import *
from asset_image_icon_choice import *
from asset_image_icon_warning import *
from asset_image_icon_snactrac import *
from asset_image_icon_success import *
from get_padding_text import *
from move_window_center import *
from play_sound import *


# Handle general popup window interaction.
def window_popup_general(
    title="Title",
    icon="warning",
    text="My, what great text you have!",
    button_false=False,
    button_none=False,
    button_true=False,
    sound=False,
):

    timeout = 0

    element_buttons = []

    if button_false:

        element_buttons.append(
            sg.Button(
                button_text="%s [ESC]" % button_false,
                font=("Roboto", 13, "bold"),
                key="-BUTTON_FALSE-",
            )
        )

    if button_none:

        element_buttons.append(
            sg.Button(
                button_text="%s [DEL]" % button_none,
                font=("Roboto", 13, "bold"),
                key="-BUTTON_NONE-",
            )
        )

    if button_true:

        element_buttons.append(
            sg.Button(
                button_text="%s [ENTER]" % button_true,
                font=("Roboto", 13, "bold"),
                key="-BUTTON_TRUE-",
            )
        )

    layout = [
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 19),
                pad=(0, 0),
            ),
        ],
        [
            sg.Push(),
            sg.Image(
                source=eval(f"icon_{icon}"),
                pad=(0, 0),
            ),
            sg.Push(),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 22),
                pad=(0, 0),
            ),
        ],
        [
            sg.Push(),
            sg.Frame(
                title=None,
                layout=[],
                size=(get_padding_text(text[0], "left"), 0),
                pad=(0, 0),
            ),
            sg.Text(
                text=text,
                font=("Roboto", 12),
                pad=(0, 0),
            ),
            sg.Frame(
                title=None,
                layout=[],
                size=(get_padding_text(text[-1], "right"), 0),
                pad=(0, 0),
            ),
            sg.Push(),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 28),
                pad=(0, 0),
            ),
        ],
        [
            sg.Push(),
            sg.Frame(
                title=None,
                layout=[],
                size=(5, 0),
                pad=(0, 0),
            ),
            *element_buttons,
            sg.Frame(
                title=None,
                layout=[],
                size=(5, 0),
                pad=(0, 0),
            ),
            sg.Push(),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 16),
                pad=(0, 0),
            ),
        ],
    ]

    window = sg.Window(
        title=title,
        layout=layout,
        finalize=True,
        modal=True,
        enable_close_attempted_event=True,
        icon=icon_snactrac,
    )

    while True:

        event, values = window.read(timeout)

        if timeout == None and (
            event == "-BUTTON_FALSE-" or event == sg.WIN_CLOSE_ATTEMPTED_EVENT
        ):

            play_sound("tick")

            window.close()

            return False

        if timeout == None and event == "-BUTTON_NONE-":

            play_sound("tick")

            window.close()

            return None

        if timeout == None and event == "-BUTTON_TRUE-":

            play_sound("tick")

            window.close()

            return True

        if timeout == 0:

            window.bind("<Escape>", "-BUTTON_FALSE-")

            if button_none:

                window.bind("<Delete>", "-BUTTON_NONE-")

            if button_true:

                window.bind("<Return>", "-BUTTON_TRUE-")

            move_window_center(window)

            timeout = None

            play_sound("pop")

            if sound:

                play_sound(sound)
