# Copyright (C) 2026 BoundWare LLC. All rights reserved.
# SnacTrac is licensed under the Apache License, Version 2.0
# See Licenses/LICENSE.txt for details.


import PySimpleGUI as sg
from asset_image_icon_input import *
from asset_image_icon_snactrac import *
from get_value_setting import *
from move_window_center import *
from play_sound import *
from window_popup_general import *


# Handle admin password popup window interaction.
def window_popup_admin_password():

    timeout = 0

    layout = [
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 19),
                pad=(0, 0),
            ),
        ],
        [
            sg.Push(),
            sg.Image(
                source=icon_input,
                pad=(0, 0),
            ),
            sg.Push(),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 24),
                pad=(0, 0),
            ),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(12, 0),
                pad=(0, 0),
            ),
            sg.Text(
                text="Admin Password:",
                font=("Roboto", 12),
                pad=(0, 0),
            ),
            sg.Frame(
                title=None,
                layout=[],
                size=(42, 0),
                pad=(0, 0),
            ),
            sg.Frame(
                title=None,
                layout=[
                    [
                        sg.Input(
                            size=(14, 1),
                            password_char="●",
                            justification="center",
                            font=("Roboto", 12),
                            key="-INPUT_ADMIN_PASSWORD-",
                            pad=(0, 0),
                        ),
                    ]
                ],
                size=(398, 65),
                pad=(0, 0),
                border_width=0,
            ),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 21),
                pad=(0, 0),
            ),
        ],
        [
            sg.Push(),
            sg.Button(
                button_text="Cancel [ESC]",
                font=("Roboto", 13, "bold"),
                key="-BUTTON_CANCEL-",
            ),
            sg.Button(
                button_text="Confirm [ENTER]",
                font=("Roboto", 13, "bold"),
                key="-BUTTON_CONFIRM-",
            ),
            sg.Push(),
        ],
    ]

    window = sg.Window(
        title="Enter Admin Password",
        size=(880, 425),
        layout=layout,
        finalize=True,
        modal=True,
        enable_close_attempted_event=True,
        icon=icon_snactrac,
    )

    while True:

        event, values = window.read(timeout)

        if timeout == None and (
            event == "-BUTTON_CANCEL-" or event == sg.WIN_CLOSE_ATTEMPTED_EVENT
        ):

            play_sound("tick")

            window.close()

            return False

        if timeout == None and event == "-BUTTON_CONFIRM-":

            play_sound("tick")

            if values["-INPUT_ADMIN_PASSWORD-"] == get_value_setting(
                setting="Admin Password"
            ):

                window.close()

                return True

            elif values["-INPUT_ADMIN_PASSWORD-"] == "":

                window.close()

                window_popup_general(
                    title="Incomplete Form",
                    text="The password must not be left blank.",
                    button_true="Okay",
                )

            else:

                window.close()

                window_popup_general(
                    title="Invalid Input",
                    text="The password entered is invalid.",
                    button_true="Okay",
                )

            return False

        if timeout == 0:

            window.bind("<Escape>", "-BUTTON_CANCEL-")

            window.bind("<Return>", "-BUTTON_CONFIRM-")

            window["-INPUT_ADMIN_PASSWORD-"].set_focus()

            move_window_center(window)

            timeout = None

            play_sound("pop")
