# Copyright (C) 2026 BoundWare LLC. All rights reserved.
# SnacTrac is licensed under the Apache License, Version 2.0
# See Licenses/LICENSE.txt for details.


import PySimpleGUI as sg
from asset_image_icon_snactrac import *
from asset_image_logo_boundware import *
from get_info import *
from get_version import *
from move_window_center import *
from play_sound import *
from window_popup_admin_password import *


# Handle info window interaction.
def window_info():

    timeout = 0

    access_key_count = 0

    layout = [
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 20),
                pad=(0, 0),
            ),
        ],
        [
            sg.Push(),
            sg.Text(
                text="INFO",
                font=("Roboto", 19, "bold"),
                pad=(0, 0),
            ),
            sg.Push(),
        ],
        [
            sg.Push(),
            sg.Text(
                text="View patch notes and credits.",
                font=("Roboto", 12, "bold"),
                pad=(0, 0),
            ),
            sg.Push(),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 28),
                pad=(0, 0),
            ),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(9, 0),
                pad=(0, 0),
            ),
            sg.Image(
                source=logo_boundware,
            ),
            sg.Frame(
                title=None,
                layout=[],
                size=(19, 0),
                pad=(0, 0),
            ),
            sg.Multiline(
                default_text=get_info(),
                disabled=True,
                size=(68, 15),
                text_color="#9B9B9B",
                font=("Roboto Mono", 7),
                pad=(0, 0),
            ),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 18),
                pad=(0, 0),
            ),
        ],
        [
            sg.Push(),
            sg.Button(
                button_text="Go Back [ESC]",
                font=("Roboto", 13, "bold"),
                key="-BUTTON_GO_BACK-",
            ),
            sg.Push(),
        ],
    ]

    window = sg.Window(
        title="SnacTrac %s - Info" % get_version(),
        size=(1655, 957),
        layout=layout,
        finalize=True,
        modal=True,
        enable_close_attempted_event=True,
        icon=icon_snactrac,
    )

    while True:

        event, values = window.read(timeout)

        if timeout == None and (
            event == "-BUTTON_GO_BACK-" or event == sg.WIN_CLOSE_ATTEMPTED_EVENT
        ):

            play_sound("tick")

            window.close()

            return "welcome"

        if timeout == None and event == "-ACCESS_KEY-":

            access_key_count += 1

            play_sound("harp_%s" % access_key_count)

            if access_key_count > 2:

                access_key_count = 0

                if window_popup_admin_password():

                    window.close()

                    return "admin"

        if timeout == 0:

            window.bind("<Escape>", "-BUTTON_GO_BACK-")

            window.bind("<End>", "-ACCESS_KEY-")

            move_window_center(window)

            timeout = None

            play_sound("pop")
