# Copyright (C) 2026 BoundWare LLC. All rights reserved.
# SnacTrac is licensed under the Apache License, Version 2.0
# See Licenses/LICENSE.txt for details.


import PySimpleGUI as sg
from asset_image_icon_snactrac import *
from clean_history import *
from get_version import *
from move_window_center import *
from play_sound import *
from window_popup_general import *


# Handle admin control panel window interaction.
def window_admin_control_panel():

    timeout = 0

    test_key_count = 0

    layout = [
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 20),
                pad=(0, 0),
            ),
        ],
        [
            sg.Push(),
            sg.Text(
                text="ADMIN CONTROL PANEL",
                font=("Roboto", 19, "bold"),
                pad=(0, 0),
            ),
            sg.Push(),
        ],
        [
            sg.Push(),
            sg.Text(
                text="Select an option to continue.",
                font=("Roboto", 12, "bold"),
                pad=(0, 0),
            ),
            sg.Push(),
        ],
        [
            sg.Frame(
                title=None,
                layout=[],
                size=(0, 26),
                pad=(0, 0),
            ),
        ],
        [
            sg.Push(),
            sg.Button(
                button_text="History [1]",
                size=(12, 1),
                font=("Roboto", 13, "bold"),
                pad=(5, 5),
                key="-BUTTON_HISTORY-",
            ),
            sg.Button(
                button_text="Stats [2]",
                size=(12, 1),
                font=("Roboto", 13, "bold"),
                pad=(5, 5),
                key="-BUTTON_STATS-",
            ),
            sg.Button(
                button_text="Event [3]",
                size=(12, 1),
                font=("Roboto", 13, "bold"),
                pad=(5, 5),
                key="-BUTTON_EVENT-",
            ),
            sg.Push(),
        ],
        [
            sg.Push(),
            sg.Button(
                button_text="Users [4]",
                size=(12, 1),
                font=("Roboto", 13, "bold"),
                pad=(5, 5),
                key="-BUTTON_USERS-",
            ),
            sg.Button(
                button_text="Items [5]",
                size=(12, 1),
                font=("Roboto", 13, "bold"),
                pad=(5, 5),
                key="-BUTTON_ITEMS-",
            ),
            sg.Button(
                button_text="Settings [6]",
                size=(12, 1),
                font=("Roboto", 13, "bold"),
                pad=(5, 5),
                key="-BUTTON_SETTINGS-",
            ),
            sg.Push(),
        ],
        [
            sg.Push(),
            sg.Button(
                button_text="Exit [ESC]",
                size=(12, 1),
                font=("Roboto", 13, "bold"),
                pad=(5, 5),
                key="-BUTTON_EXIT-",
            ),
            sg.Push(),
        ],
    ]

    window = sg.Window(
        title="SnacTrac %s - Admin Control Panel" % get_version(),
        size=(1244, 607),
        layout=layout,
        finalize=True,
        modal=True,
        enable_close_attempted_event=True,
        icon=icon_snactrac,
    )

    while True:

        event, values = window.read(timeout)

        if timeout == None and (
            event == "-BUTTON_EXIT-" or event == sg.WIN_CLOSE_ATTEMPTED_EVENT
        ):

            play_sound("tick")

            if window_popup_general(
                title="Confirm Exit",
                icon="exit",
                text="Are you sure you want to exit to the welcome window?",
                button_false="Cancel",
                button_true="Confirm",
            ):

                window.close()

                return "welcome"

        if timeout == None and event == "-BUTTON_HISTORY-":

            play_sound("tick")

            window.close()

            return "history"

        if timeout == None and event == "-BUTTON_STATS-":

            play_sound("tick")

            window.close()

            return "stats"

        if timeout == None and event == "-BUTTON_EVENT-":

            play_sound("tick")

            window.close()

            return "event"

        if timeout == None and event == "-BUTTON_USERS-":

            play_sound("tick")

            window.close()

            return "users"

        if timeout == None and event == "-BUTTON_ITEMS-":

            play_sound("tick")

            window.close()

            return "items"

        if timeout == None and event == "-BUTTON_SETTINGS-":

            play_sound("tick")

            window.close()

            return "settings"

        if timeout == None and event == "-TEST_KEY-":

            test_key_count += 1

            play_sound("pickaxe_%s" % test_key_count)

            if test_key_count > 2:

                window.close()

                return "test"

        if timeout == 0:

            window.bind("<Escape>", "-BUTTON_EXIT-")

            window.bind("1", "-BUTTON_HISTORY-")

            window.bind("2", "-BUTTON_STATS-")

            window.bind("3", "-BUTTON_EVENT-")

            window.bind("4", "-BUTTON_USERS-")

            window.bind("5", "-BUTTON_ITEMS-")

            window.bind("6", "-BUTTON_SETTINGS-")

            window.bind("9", "-TEST_KEY-")

            move_window_center(window)

            timeout = None

            play_sound("pop")

            if clean_history():

                window_popup_general(
                    title="History Cleaned",
                    icon="success",
                    text="History exceeded 500 rows and was trimmed to 120.",
                    button_true="Okay",
                )
