# Copyright (C) 2026 BoundWare LLC. All rights reserved.
# SnacTrac is licensed under the Apache License, Version 2.0
# See Licenses/LICENSE.txt for details.


import pygame
import PySimpleGUI as sg
import time
from asset_font_roboto_bold import *
from asset_font_roboto_mono_regular import *
from asset_font_roboto_regular import *
from get_value_setting import *
from init_directory import *
from init_history import *
from init_items import *
from init_notifications import *
from init_settings import *
from init_users import *
from load_font import *
from set_value_setting import *
from window_admin_control_panel import *
from window_event import *
from window_history import *
from window_info import *
from window_items import *
from window_profile import *
from window_program_setup_wizard import *
from window_register import *
from window_settings import *
from window_stats import *
from window_store import *
from window_test import *
from window_users import *
from window_welcome import *


window_state = "welcome"

username = None

mode = "user"

load_font(roboto_regular)

load_font(roboto_bold)

load_font(roboto_mono_regular)

sg.set_options(tooltip_time=0, scaling=4.2)

pygame.mixer.pre_init(buffer=2048)

pygame.mixer.init()

init_directory()

init_settings()

init_users()

init_items()

init_notifications()

init_history()


if get_value_setting("Launch Program Setup Wizard") == True:

    if window_program_setup_wizard():

        set_value_setting("Admin Password", "2439")

        set_value_setting("Launch Program Setup Wizard", False)

    else:

        window_state = "exit"

while window_state != "exit":

    if window_state == "welcome":

        window_state, username, mode = window_welcome()

    elif window_state == "store":

        window_state, username, mode = window_store(username, mode)

    elif window_state == "profile":

        window_state = window_profile(username)

    elif window_state == "register":

        window_state = window_register()

    elif window_state == "info":

        window_state = window_info()

    elif window_state == "admin":

        window_state = window_admin_control_panel()

    elif window_state == "history":

        window_state = window_history()

    elif window_state == "stats":

        window_state = window_stats()

    elif window_state == "event":

        window_state = window_event()

    elif window_state == "users":

        window_state, username, mode = window_users()

    elif window_state == "items":

        window_state = window_items()

    elif window_state == "settings":

        window_state = window_settings()

    elif window_state == "test":

        window_state = window_test()

time.sleep(0.5)
