# Copyright (C) 2026 BoundWare LLC. All rights reserved.
# SnacTrac is licensed under the Apache License, Version 2.0
# See Licenses/LICENSE.txt for details.


import sqlite3


# Create users table in database.
def init_users():

    conn = sqlite3.connect("Data/Database.db")

    cur = conn.cursor()

    conn.execute(
        """CREATE TABLE IF NOT EXISTS Users
        (
        "First Name" TEXT NOT NULL CHECK(typeof("First Name") = 'text'),
        "Last Name" TEXT NOT NULL CHECK(typeof("Last Name") = 'text'),
        "Username" TEXT NOT NULL PRIMARY KEY UNIQUE CHECK(typeof("Username") = 'text'),
        "Password" TEXT NOT NULL CHECK(typeof("Password") = 'text'),
        "Locked" INTEGER NOT NULL DEFAULT 0 CHECK(typeof("Locked") = 'integer'),
        "Ask Log Out" INTEGER NOT NULL DEFAULT 1 CHECK(typeof("Ask Log Out") = 'integer'),
        "Search Mode" TEXT NOT NULL DEFAULT 'Name' CHECK(typeof("Search Mode") = 'text'),
        "Balance" REAL NOT NULL DEFAULT 0 CHECK(typeof("Balance") = 'real')
        )"""
    )

    cur.close()

    conn.close()
