# Copyright (C) 2026 BoundWare LLC. All rights reserved.
# SnacTrac is licensed under the Apache License, Version 2.0
# See Licenses/LICENSE.txt for details.


import os
import yaml


# Create settings file.
def init_settings():

    path = "Data/Settings.yaml"

    defaults = {
        "Admin Password": "2439",
        "Max User Debt": 30.0,
        "Guest Mode Enabled": False,
        "Launch Program Setup Wizard": True,
    }

    if not os.path.exists(path):

        with open(path, "w") as file:

            yaml.dump(defaults, file)
