# Copyright (C) 2026 BoundWare LLC. All rights reserved.
# SnacTrac is licensed under the Apache License, Version 2.0
# See Licenses/LICENSE.txt for details.


import sqlite3


# Create notifications table in database.
def init_notifications():

    conn = sqlite3.connect("Data/Database.db")

    cur = conn.cursor()

    conn.execute(
        """CREATE TABLE IF NOT EXISTS Notifications
        (
        "ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE CHECK(typeof("ID") = 'integer'),
        "Username" TEXT NOT NULL REFERENCES Users("Username") ON DELETE CASCADE CHECK(typeof("Username") = 'text'),
        "Priority" INTEGER NOT NULL CHECK(typeof("Priority") = 'integer'),
        "Message" TEXT NOT NULL CHECK(typeof("Message") = 'text')
        )"""
    )

    cur.close()

    conn.close()
