# Copyright (C) 2026 BoundWare LLC. All rights reserved.
# SnacTrac is licensed under the Apache License, Version 2.0
# See Licenses/LICENSE.txt for details.


import sqlite3


# Create items table in database.
def init_items():

    conn = sqlite3.connect("Data/Database.db")

    cur = conn.cursor()

    conn.execute(
        """CREATE TABLE IF NOT EXISTS Items
        (
        "ID" INTEGER NOT NULL UNIQUE DEFAULT 0 CHECK(typeof("ID") = 'integer'),
        "Name" TEXT NOT NULL UNIQUE CHECK(typeof("Name") = 'text'),
        "Price" REAL NOT NULL DEFAULT 0 CHECK(typeof("Price") = 'real'),
        "Profit" REAL NOT NULL DEFAULT 0 CHECK(typeof("Profit") = 'real'),
        "Stock" INTEGER NOT NULL DEFAULT 0 CHECK(typeof("Stock") = 'integer'),
        "Barcode" TEXT UNIQUE CHECK(typeof("Barcode") = 'text' OR "Barcode" IS NULL),
        "Image" BLOB CHECK(typeof("Image") = 'blob' OR "Image" IS NULL)
        )"""
    )

    cur.close()

    conn.close()
