# Copyright (C) 2026 BoundWare LLC. All rights reserved.
# SnacTrac is licensed under the Apache License, Version 2.0
# See Licenses/LICENSE.txt for details.


import sqlite3


# Create history table in database.
def init_history():

    conn = sqlite3.connect("Data/Database.db")

    cur = conn.cursor()

    conn.execute(
        """CREATE TABLE IF NOT EXISTS History
        (
        "ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE CHECK(typeof("ID") = 'integer'),
        "Date" TEXT NOT NULL CHECK(typeof("Date") = 'text'),
        "Time" TEXT NOT NULL CHECK(typeof("Time") = 'text'),
        "User" TEXT DEFAULT NULL CHECK(typeof("User") = 'text' OR "User" IS NULL),
        "Mode" TEXT NOT NULL CHECK(typeof("Mode") = 'text'),
        "Action" TEXT NOT NULL CHECK(typeof("Action") = 'text'),
        "Description" TEXT NOT NULL CHECK(typeof("Description") = 'text'),
        "Total" REAL DEFAULT NULL CHECK(typeof("Total") = 'real' OR "Total" IS NULL),
        "Old Balance" REAL DEFAULT NULL CHECK(typeof("Old Balance") = 'real' OR "Old Balance" IS NULL),
        "New Balance" REAL DEFAULT NULL CHECK(typeof("New Balance") = 'real' OR "New Balance" IS NULL),
        "Old Stock" INTEGER DEFAULT NULL CHECK(typeof("Old Stock") = 'integer' OR "Old Stock" IS NULL),
        "New Stock" INTEGER DEFAULT NULL CHECK(typeof("New Stock") = 'integer' OR "New Stock" IS NULL),
        "Profit" REAL DEFAULT NULL CHECK(typeof("Profit") = 'real' OR "Profit" IS NULL)
        )"""
    )

    cur.close()

    conn.close()
