# Copyright (C) 2026 BoundWare LLC. All rights reserved.
# SnacTrac is licensed under the Apache License, Version 2.0
# See Licenses/LICENSE.txt for details.


# Return appropriate text spacing.
def get_padding_text(character, side):

    padding_default = (5, 5)

    padding_mapped = {
        "A": (8, 8),
        "B": (5, 6),
        "C": (6, 6),
        "D": (5, 6),
        "E": (5, 7),
        "F": (5, 7),
        "G": (6, 5),
        "H": (3, 4),
        "I": (4, 4),
        "J": (7, 4),
        "K": (5, 9),
        "L": (5, 7),
        "M": (5, 4),
        "N": (4, 4),
        "O": (6, 6),
        "P": (4, 7),
        "Q": (6, 6),
        "R": (5, 8),
        "S": (7, 7),
        "T": (8, 7),
        "U": (6, 6),
        "V": (8, 8),
        "W": (7, 8),
        "X": (7, 7),
        "Y": (8, 8),
        "Z": (7, 7),
        "a": (6, 6),
        "b": (5, 7),
        "c": (7, 7),
        "d": (7, 5),
        "e": (7, 7),
        "f": (7, 9),
        "g": (6, 5),
        "h": (5, 5),
        "i": (5, 5),
        "j": (10, 5),
        "k": (5, 8),
        "l": (5, 5),
        "m": (5, 5),
        "n": (5, 5),
        "o": (6, 6),
        "p": (5, 6),
        "q": (8, 5),
        "r": (5, 8),
        "s": (6, 6),
        "t": (9, 7),
        "u": (5, 5),
        "v": (8, 8),
        "w": (7, 7),
        "x": (7, 7),
        "y": (8, 8),
        "z": (7, 7),
        "0": (6, 6),
        "1": (5, 0),
        "2": (6, 7),
        "3": (6, 6),
        "4": (7, 8),
        "5": (5, 7),
        "6": (6, 6),
        "7": (7, 7),
        "8": (6, 6),
        "9": (6, 6),
        ".": (5, 5),
        ",": (8, 6),
        "!": (5, 5),
        "?": (7, 6),
        ":": (5, 6),
        ";": (8, 6),
        "'": (6, 6),
        '"': (5, 6),
        "(": (5, 8),
        ")": (8, 6),
        "[": (5, 9),
        "]": (9, 5),
        "{": (7, 8),
        "}": (8, 7),
        "-": (8, 8),
        "_": (9, 8),
        "=": (5, 6),
        "+": (7, 7),
        "/": (8, 7),
        "\\": (7, 8),
        "|": (4, 5),
        "`": (7, 5),
        "~": (6, 6),
        "@": (6, 6),
        "#": (6, 8),
        "$": (6, 6),
        "%": (6, 6),
        "^": (7, 7),
        "&": (6, 8),
        "*": (8, 7),
        "<": (7, 5),
        ">": (5, 7),
    }

    left_padding, right_padding = padding_mapped.get(character, padding_default)

    if side == "left":

        return left_padding

    elif side == "right":

        return right_padding
