# Copyright (C) 2026 BoundWare LLC. All rights reserved.
# SnacTrac is licensed under the Apache License, Version 2.0
# See Licenses/LICENSE.txt for details.


from get_year import *


# Return program info.
def get_info():

    return (
        " ------------------------------------------------------------------\n"
        " General\n"
        " ------------------------------------------------------------------\n"
        f" Copyright (C) {get_year()} BoundWare LLC. All rights reserved.\n"
        " Developed by Andrew Bradshaw\n"
        " Project ID: 0\n"
        " ------------------------------------------------------------------\n"
        " Patch Notes\n"
        " ------------------------------------------------------------------\n"
        " v1.9.8\n"
        "   • Various improvements.\n"
        "   • Finalized BoundWare logo.\n"
        "   • Completed program setup wizard.\n"
        "   • First (...kinda) official release. Yay!\n"
        "   • Switched license from MIT to Apache 2.0.\n"
        "   • Added automatic history cleaning to prevent slowdown.\n"
        "   • Removed program exit keybind to prevent accidental exit.\n"
        '   • Fixed bug in \"Items\" window where selection was editable.\n'
        "   • Retroactively renamed 0.1.0 versions to 0.9.0. (because).\n"
        "   • Fixed Admin Control Panel discrepancies with users and items.\n"
        "   • Renamed setup wizard setting. (delete previous Settings.yaml)\n"
        " v0.9.8\n"
        "   • Made more branding tweaks.\n"
        " v0.9.7\n"
        "   • Updated attribution.\n"
        "   • Made branding tweaks.\n"
        "   • Added initial onboarding.\n"
        "   • Added ability to reset item images.\n"
        "   • Fixed bug where item ids were not generated correctly.\n"
        '   • Renamed "Launch Configuration" to "Initial Onboarding".\n'
        " v0.9.6\n"
        "   • Added item images.\n"
        " v0.9.5\n"
        "   • Added user payments to history.\n"
        "   • Item images not yet implemented.\n"
        "   • Fixed crash when updating item barcodes.\n"
        "   • Added popups when admin changes item properties.\n"
        " v0.9.4\n"
        "   • Yes. Yes I am.\n"
        "   • Nearly feature complete.\n"
        " v0.9.3\n"
        "   • Took a break.\n"
        "   • Added items window.\n"
        "   • Added users window.\n"
        "   • Added profile window.\n"
        "   • Am I really gonna rewrite this thing again?\n"
        " v0.9.2\n"
        "   • Added minor branding changes.\n"
        " v0.9.1\n"
        "   • Added info window.\n"
        "   • Added company logo.\n"
        "   • Added event window.\n"
        "   • Added stats window.\n"
        "   • Added history window.\n"
        "   • Added settings window.\n"
        "   • Added admin control panel.\n"
        " v0.9.0\n"
        "   • Got stuck in development hell.\n"
        "   • Removed a truckload of spaghetti code.\n"
        "   • Nuked and restarted development six times.\n"
        "   • Devoted excessive amounts of time to logos and icons.\n"
        "   • Begrudgingly accepted very insignificant imperfections.\n"
        " ------------------------------------------------------------------\n"
        " Credits\n"
        " ------------------------------------------------------------------\n"
        "   • AutoPyToExe v2.43.3\n"
        "   • Pillow v11.1.0\n"
        "   • PyGame v2.5.2\n"
        "   • Pyglet v2.0.15\n"
        "   • PyInstaller v6.12.0\n"
        "   • PySimpleGUI v4.61.0.206\n"
        "   • Python v3.12.0\n"
        "   • PyYAML v6.0.1\n"
        " ------------------------------------------------------------------\n"
        " Appreciation\n"
        " ------------------------------------------------------------------\n"
        " Thank you to all the developers who made this project possible!\n"
    )
