# Copyright (C) 2026 BoundWare LLC. All rights reserved.
# SnacTrac is licensed under the Apache License, Version 2.0
# See Licenses/LICENSE.txt for details.


from convert_money import *
from get_marker_empty import *


# Return formatted history data for history window.
def format_history_admin(data_history):

    data_history_formatted = [entry.copy() for entry in data_history]

    for entry in data_history_formatted:

        entry.append(entry.pop(0))

    data_history_formatted = [
        [
            (
                convert_money(value)
                if isinstance(value, float)
                else get_marker_empty() if value is None else value
            )
            for value in entry
        ]
        for entry in data_history_formatted
    ]

    data_history_formatted.reverse()

    return data_history_formatted
