# Copyright (C) 2026 BoundWare LLC. All rights reserved.
# SnacTrac is licensed under the Apache License, Version 2.0
# See Licenses/LICENSE.txt for details.


# Convert between float and dollar-formatted string.
def convert_money(amount):

    if isinstance(amount, str):

        return round(float(amount.replace("$", "").replace(",", "")), 2)

    elif isinstance(amount, float):

        return f"-${abs(amount):,.2f}" if amount < 0 else f"${amount:,.2f}"
