# Copyright (C) 2026 BoundWare LLC. All rights reserved.
# SnacTrac is licensed under the Apache License, Version 2.0
# See Licenses/LICENSE.txt for details.


import sqlite3


# Prune history down to 120 entries if it exceeds 500 entries.
def clean_history():

    conn = sqlite3.connect("Data/Database.db")

    cur = conn.cursor()

    cur.execute("SELECT COUNT(*) FROM History")

    total_entries = cur.fetchone()[0]

    if total_entries >= 500:

        cur.execute("""
            DELETE FROM History
            WHERE rowid NOT IN (
                SELECT rowid FROM History
                ORDER BY rowid DESC
                LIMIT 120
            )
        """)

        conn.commit()

        cur.close()

        conn.close()

        return True

    cur.close()

    conn.close()

    return False
