# Copyright (C) 2026 BoundWare LLC. All rights reserved.
# SnacTrac is licensed under the Apache License, Version 2.0
# See Licenses/LICENSE.txt for details.


import sqlite3


# Add new item to database.
def append_items():

    conn = sqlite3.connect(database="Data/Database.db")

    cur = conn.cursor()

    cur.execute("SELECT ID FROM Items")

    ids = [row[0] for row in cur.fetchall()]

    id = 1

    while id in ids:

        id += 1

    number = 1

    while True:

        name = f"New Item {number}"

        cur.execute("SELECT COUNT(*) FROM Items WHERE name = ?", (name,))

        if cur.fetchone()[0] == 0:

            break

        number += 1

    cur.execute(
        """
        INSERT INTO Items ("ID", "Name")
        VALUES (?, ?)
        """,
        (id, name),
    )

    conn.commit()

    cur.close()

    conn.close()
