# Copyright (C) 2026 BoundWare LLC. All rights reserved.
# SnacTrac is licensed under the Apache License, Version 2.0
# See Licenses/LICENSE.txt for details.


import sqlite3
from datetime import datetime


# Add history table entry to database.
def append_history(
    user=None,
    mode=None,
    action=None,
    description=None,
    total=None,
    balance_old=None,
    balance_new=None,
    stock_old=None,
    stock_new=None,
    profit=None,
):

    conn = sqlite3.connect(database="Data/Database.db")

    cur = conn.cursor()

    cur.execute(
        """
        INSERT INTO History ("Date", "Time", "User", "Mode", "Action", "Description", "Total", "Old Balance", "New Balance", "Old Stock", "New Stock", "Profit")
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        """,
        (
            datetime.now().strftime("%Y-%m-%d"),
            datetime.now().strftime("%H:%M:%S"),
            user,
            mode,
            action,
            description,
            total,
            balance_old,
            balance_new,
            stock_old,
            stock_new,
            profit,
        ),
    )

    conn.commit()

    cur.close()

    conn.close()
